# **National Human Rights Museum Digital Collection**

[![Website screenshot][image1]](https://collections.culture.tw/nhrm_collectionsweb/Default.aspx)

### **Reviewed by:** Connie Cordon

### **Review date:** April 2, 2025

### **Site Link**: [https://collections.culture.tw/nhrm\_collectionsweb/Default.aspx](https://collections.culture.tw/nhrm_collectionsweb/Default.aspx)

### **Archive Link:** [https://archive.ph/WylAk](https://archive.ph/WylAk)

### **Keywords:** Political Science, Postcolonial Studies, Cultural Heritage

### **Data Sources:**
* Family letters  
* Manuscripts  
* Paintings  
* Calligraphy  
* Newspaper  
* Journals  
* Books  
* Photographs

### **Processes:**
* Scanning and photographing artifacts with ColorChecker Rendition Chart (Macbeth chart) to maintain consistent color balance and exposure for all images.  
* Standardize data of object weight, measurement, material, author/owner, date of item, collection name, and author/owner, and how the artifact was obtained.  
* Artifacts are accompanied by a small description of the item, followed by a standard biography of the prisoner and the references used.

### **Presentation:**
The project is presented as a digital archive organized by category of the item. The user is intended to explore this digital archive by browsing each category, which has a photographic icon displayed above the page. The collection is organized by categories of “manuscript,” “multimedia,” “letters,” “paintings and calligraphy,” “newspaper,” “journals,” “books,” “artifacts,” and “photography.” Below the top half of the page, a collected sample of artifacts are displayed under the “Collection Selection.” They are handpicked artifacts from researchers that are randomly displayed each time the page is refreshed. A navigation bar on the top includes tabs like collection search, about us, browse by collection, and contact. 

### **Digital Tools Used:**
* Web frameworks: Microsoft [ASP.NET](http://ASP.NET)  
* UI frameworks: Bootstrap  
* Tag managers: Google Tag Managers  
* JavaScript libraries: jQuery, Slick  
* CDN: Cloudflare  
* Analytics: Google Analytics  
* Misc: Popper

### **Languages:**
* Mandarin  
* English (reviewed using Google Translate)

### **Review**
The [Cultural Collections](https://collections.culture.tw/nhrm_collectionsweb/Default.aspx) is a smaller project of a larger organization that was launched on December 13, 2017 when the Presidential Office started the “[National Human Rights Museum Organization Act](https://www.nhrm.gov.tw/w/nhrmEN/Forming#:~:text=28th%20and%20the%20President%20promulgated,past%20victims%20of%20political%20persecution.).” This organization completed the preliminary collection after 6 years of preparation, and in 2018, the National Human Rights Museum was officially established. It promotes the collection and research of political victims of human rights violations that occurred in Taiwan during a 40-year repressive rule, known as the White Terror Period. Due to the constant monitoring and terrorizing of Taiwanese citizens, the collective memory of political suppression and losing loved ones via detainment, imprisonment, and/or death, is not an openly discussed topic. The National Human Rights Museum established this “Collection and Research and Archives Center” as a means to accept donations from families of victims, who are lucky enough to have any physical memorabilia.

<br>
The aim is to collect as many personal relics and artifacts of political prisoners and preserve them for review, restoration, digitization, and display. This is to honor the victims and the physical materials left behind, which serves as a form of remembrance to the people. By navigating through categories of artifacts, the user is able to read the letters written by/to prisoners, photographs taken during their detainment, their favorite books, handmade crafts created using the limited materials on the island and from shipments from family, their artwork and calligraphy, and even musical instruments. The collection also accepts memorabilia of the political prisoner post-incarceration, to include the life that was led after their detainment. Some prisoners now work at the National Human Rights Museum as tour guides, offering walking tours of the prison to visitors.

<br>
For every artifact, a small biography of the prisoner is included following the item description. The biography highlights the prisoner’s birthdate, his educational background, how they were accused of dissent, and their life’s accomplishments after prison release, and references.

<br>
The user interaction of the collection allows navigation through what are essentially anonymous and private letters written during a very vulnerable period. Since letters were also under surveillance, prisoners were limited as to what topics they could discuss with loved ones. While reading through, the user is constantly reminded of what can’t be communicated in the letters and the collective silence everyone experienced.

<br>
One aspect I like is the query search. You can filter the search results by keyword, collection name, year, subject category, author, and accession number. You can view the results in a grid-like display which shows the image in a smaller icon, or item-list display, which lists the accession number, collection name, author, category, and era. Using the Google Translate add-on in Chrome, it’s easier for English speakers to navigate the contents available, which can be up to 14,000 items for a single individual.

### **How are the collaborative aspects reflected in the project and are there elements that work particularly well?** 
I believe the collaborative aspects are strong. Considering the suppression of any political activism and the taboo nature of being a survivor of the White Terror, the academics and researchers had to open up a portal of discussion amongst a traumatized community.

### **Do you see an opportunity for collaboration that would be helpful to the project?**
I can see translations being added into this project, but considering the language history of the country I don’t feel so inclined for the written content to be available to everyone.

[image1]: <data:image/png;base64,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>